<?php
/*
Form
*/
//calculator form shortcode

function sp_claim_calculator(){
	global $wpdb;
	$cityTable = $wpdb->prefix.'claimassist_city';
	$priceTable = $wpdb->prefix.'claim_assist';
	$result = $wpdb->get_results("select p.*, c.city_name from $priceTable as p, $cityTable c WHERE p.city_id = c.id  ");
	if(!empty($result)){
		ob_start();
	?>
      
      <link rel="stylesheet" type="text/css" href="<?php echo plugin_dir_url(__FILE__) . 'css/style.css' ?>">
      <div class="container claim_calculator" onLoad="set_globals()" >
         <div class="row">
            <div class="col-sm-12">
               <form>
                  <div class="row">
                     <div class="col-sm-12">
                        <div class="heading-title heading-border-bottom heading-color">
                           <h3>Step 1</h3>
                        </div>
                        <div class="col-sm-3 bottom-padding">
                           <label for="selunit">Choose Area Unit:</label>
                           <select class="form-control" name="area_unitname" onchange="change_area_unit(this.form)">
							  <option value="" selected>Select Area</option>
                              <option value="metres" >Sq.metres</option>
                              <option value="sqft">Sq.feet</option>
                           </select>
                        </div>
                        <div class="col-sm-3 bottom-padding">
                           <label for="ground">Ground Floor Area:</label>
                           <input type="text" class="form-control" name="ground" value="0" onkeyup="add_area(this.form)" >
                        </div>
                        <div class="col-sm-3 bottom-padding">
                           <label for="first">First Floor Area:</label>
                           <input type="text" class="form-control" name="first" value="0" onkeyup="add_area(this.form)">
                        </div>
                        <div class="col-sm-3 bottom-padding">
                           <label for="first">Total Area:</label>
                           <input type="text" class="form-control readonlybg" readonly name="total_area" id="total_area" value="0" >
                        </div>
                     </div>
                  </div>
                  <div class="row">
                     <div class="col-sm-3 bottom-padding">
                        <div class="heading-title heading-border-bottom heading-color"><h3>Step 2</h3></div>
                        <label for="type">Choose House Type:</label>
                        <input type="radio" name="type" onclick="change_rooms(this.form,2,3,'terraced_twon_house_bad_')" checked value="t">Terraced (2 or 3 Bed)<br>
                        <input type="radio" name="type" onclick="change_rooms(this.form,3,4,'semi_detached_bad_')" value="s">Semi-detached (3 or 4 Bed)<br>
                        <input type="radio" name="type" onclick="change_rooms(this.form,4,4,'detached_bad_')" value="d">Detached (4 Bed)<br>
                        <input type="radio" name="type" onclick="change_rooms(this.form,4,4,'detached_bungalow_bad_')" value="b">Detached Bungalow (4 Bed)
                     </div>
                     <div class="col-sm-3 bottom-padding">
                        <div class="heading-title heading-border-bottom heading-color"><h3>Step 3</h3></div>
                        <label for="bedrooms">Select Number Of Bedrooms:</label>
                        <select name="bedrooms" class="form-control" onchange="bedroom_change(this.form)">
                           <option value="2" class="form-control" selected>2</option>
                           <option value="3" class="form-control">3</option>
                        </select>
                     </div>
                     <div class="col-sm-3 bottom-padding">
                        <div class="heading-title heading-border-bottom heading-color"><h3>Step 4</h3></div>
                        <label for="loc">Choose Location:</label>
                        <?php
                           $resultcity = $wpdb->get_results("select * from $cityTable");
                           if(!empty($resultcity))
                           {
							   $i=0;
                              foreach ($resultcity as $row) {
                                ?>
                                 <input type="radio" name="citylocation" onclick="city_change(this.form,'<?php echo str_replace(" ","_",substr($row->city_name,1,-1)) ;?>')" <?php if($i==0){ ?> checked <?php } ?> value="<?php echo substr($row->city_name,0,2) ;?>"><?php echo $row->city_name; ?><br>
                                <?php 
								$i++;
                              }
                           }else {
                              echo "record not found";
                           }
                           ?>
                     </div>
                     <div class="col-sm-3 bottom-padding">
                        <div class="heading-title heading-border-bottom heading-color">
                           <h3>Rebuild Cost</h3>
                        </div>
                        <div class="col-sm-6">
                           <label for="rebuild_cost">Cost &#8364;:</label>
                           <input type="text" class="form-control readonlybg" id="rebuild_cost" readonly name="rebuild_cost" value="" >
                        </div>
                        <div class="col-sm-6">
                           <label for="rebuild_cost_per">Per:</label>
                           <input type="text" class="form-control readonlybg" readonly name="rebuild_cost_per" value="Sq.metres" >
                        </div>
                     </div>
                  </div>
                  
                  <div class="row">
                     <div class="col-sm-12">
                        <div class="col-sm-4 bottom-padding">
                           <label for="area2">Total Area:</label>
                           <input type="text" class="form-control readonlybg" readonly name="area2" value="0" >
                        </div>
                        <div class="col-sm-4 bottom-padding">
                           <label for="unitcost2">X Cost &#8364;:</label>
                           <input type="text" readonly class="form-control readonlybg" name="rebuild_cost2" value="1842.00">
                        </div>
                        <div class="col-sm-4 bottom-padding">
                           <label for="subtotal">VAR Sub-Total 1 &#8364;:</label>
                           <input type="text" readonly class="form-control readonlybg" name="subtotal1" value="0.00">
                        </div>
                     </div>
                  </div>
               
                  <div class="row">
                     <div class="col-sm-6">
                        <div class="heading-title heading-border-bottom heading-color">
                           <h3>Step 5</h3>
                        </div>
                        <div class="col-sm-6 bottom-padding">
                           <label for="selgarage">Add Garage:</label>
                           <select name="selgarage" class="form-control" onchange="bedwise_price(this.form)">
                              <option value="0" selected>None</option>
                              <option value="1">Single Bay</option>
                              <option value="2">Double Bay</option>
                           </select>
                        </div>
                        <div class="col-sm-6 bottom-padding">
                           <label>Cost &#8364;:</label>
                           <input type="text" readonly class="form-control readonlybg"  name="garage" value="0.00" size="12" >
                        </div>
                     </div>
                     <div class="col-sm-6">
                        <div class="heading-title heading-border-bottom heading-color">
                           <h3>Step 6</h3>
                        </div>
                        <div class="col-sm-6 bottom-padding">
                           <label for="fittings">Add1 special finishes/fittings &#8364;:</label> 
                           <input type="text" name="fittings" class="form-control" placeholder="Hardwood Floors etc..." onchange="fitting_change(this.form)">
                        </div>
                        <div class="col-sm-6 bottom-padding">
                           <label for="subtotal">VAR Sub-Total 2 &#8364;:</label>
                           <input type="text" readonly class="form-control readonlybg" name="subtotal2" value="0.00" >
                        </div>
                     </div>
                  </div>
                  <div class="row">                    
                     <div class="col-sm-12">
                        <div class="heading-title heading-border-bottom heading-color">
                           <h3>VAR Total:</h3>
                        </div>
                        <div class="col-sm-3 bottom-padding">
                           <label for="finaltotal">Total Value At Risk &#8364;:</label>
                           <input type="text" name="finaltotal" class="form-control readonlybg" readonly value="0.00" >
                        </div>
                        <div class="col-sm-3 bottom-padding">
                           <label for="reset">&nbsp</label>
                           <button type="reset" name="reset " class="btn btn-primary" onclick="set_globals()"> <i class="fa fa-sync"></i>Reset Form</button>
                        </div>
                     </div>
                  </div>
               </form>
            </div>
         </div>
      </div>
<script type="text/javascript" src="<?php echo plugin_dir_url(__FILE__);?>/js/price-calculate.js"></script>
<?php

$garageTable = $wpdb->prefix.'claim_garage_price';
$garageResult = $wpdb->get_row("select * from " .$garageTable." ");
?>	  
<script type="text/javascript">
jQuery(document).ready(function(){
	set_globals();
});
      var groundbeds;
	  var groundtype;
	  var groundunit;
	  var groundlocation;
	  var groundfitting;
	  var groundother;

	function set_globals(){
	  groundbeds = "2";
	  groundtype = "terraced_twon_house_bad_";
	  groundunit = "metres";
	  groundlocation = "<?php echo str_replace(' ','_',substr($result[0]->city_name,1,-1)); ?>";
	  groundfitting = "0";
	  groundother = "0";  
	}
	function bedwise_price(currentform){
	<?php	
		foreach($result as $pricedata){ ?>
			var terraced_twon_house_bad_2<?php echo substr(str_replace(" ","_",$pricedata->city_name),1,-1); ?>sqft = "<?php echo $pricedata->terraced_twon_house_bad_2_sq_ft; ?>";		
			var terraced_twon_house_bad_2<?php echo substr(str_replace(" ","_",$pricedata->city_name),1,-1); ?>metres = '<?php echo $pricedata->terraced_twon_house_bad_2_sq_meter; ?>';
			var terraced_twon_house_bad_3<?php echo substr(str_replace(" ","_",$pricedata->city_name),1,-1); ?>sqft = '<?php echo $pricedata->terraced_twon_house_bad_3_sq_ft; ?>';
			var terraced_twon_house_bad_3<?php echo substr(str_replace(" ","_",$pricedata->city_name),1,-1); ?>metres = '<?php echo $pricedata->terraced_twon_house_bad_3_sq_meter; ?>';
			var semi_detached_bad_3<?php echo substr(str_replace(" ","_",$pricedata->city_name),1,-1); ?>sqft = '<?php echo $pricedata->semi_detached_bad_3_sq_ft; ?>';
			var semi_detached_bad_3<?php echo substr(str_replace(" ","_",$pricedata->city_name),1,-1); ?>metres = '<?php echo $pricedata->semi_detached_bad_3_sq_meter; ?>';
			var semi_detached_bad_4<?php echo substr(str_replace(" ","_",$pricedata->city_name),1,-1); ?>sqft = '<?php echo $pricedata->semi_detached_bad_4_sq_ft; ?>';
			var semi_detached_bad_4<?php echo substr(str_replace(" ","_",$pricedata->city_name),1,-1); ?>metres = '<?php echo $pricedata->semi_detached_bad_4_sq_meter; ?>';
			var detached_bad_4<?php echo substr(str_replace(" ","_",$pricedata->city_name),1,-1); ?>sqft = '<?php echo $pricedata->detached_bad_4_sq_ft; ?>';
			var detached_bad_4<?php echo substr(str_replace(" ","_",$pricedata->city_name),1,-1); ?>metres = '<?php echo $pricedata->detached_bad_4_sq_meter; ?>';
			var detached_bungalow_bad_4<?php echo substr(str_replace(" ","_",$pricedata->city_name),1,-1); ?>sqft = '<?php echo $pricedata->detached_bungalow_bad_4_sq_ft; ?>';
			var detached_bungalow_bad_4<?php echo substr(str_replace(" ","_",$pricedata->city_name),1,-1); ?>metres = '<?php echo $pricedata->detached_bungalow_bad_4_sq_meter; ?>';

		<?php } ?>
		  var singlebay_garage = "<?php echo $garageResult->single_bay ?>";
		  var doublebay_garage = "<?php echo $garageResult->double_bay ?>";
		
		  var total = groundtype + groundbeds + groundlocation + groundunit;		
		  var rebuildunitcost = eval(total);
		  var rebuildsubtotal = currentform.total_area.value * rebuildunitcost;
		  var claimgarage = 0;

		  var claimfitting = groundfitting;
		  var claimother = groundother;

		  if(currentform.selgarage.value == 1){
			claimgarage = singlebay_garage;
		  }

		  if(currentform.selgarage.value == 2){
			claimgarage = doublebay_garage;  
		  }
		  
		  var claimsubtotal2 = rebuildsubtotal + eval(claimgarage) + eval(claimfitting) + eval(claimother);
		  var claimfinaltotal = claimsubtotal2;
		
		currentform.rebuild_cost.value   = ConvertToEurosCents(rebuildunitcost);
		currentform.rebuild_cost2.value  = ConvertToEurosCents(rebuildunitcost);
		currentform.subtotal1.value		 = ConvertToEurosCents(rebuildsubtotal);
		currentform.garage.value		 = ConvertToEurosCents(claimgarage);
		currentform.subtotal2.value 	 = ConvertToEurosCents(claimsubtotal2);
		currentform.finaltotal.value 	 = ConvertToEurosCents(claimfinaltotal);
		
	}
	
	function change_area_unit(currentform){		
		groundunit = currentform.area_unitname.value;
	    if (groundunit=='sqft'){
			currentform.rebuild_cost_per.value = "Sq. foot";
		}
		else{
			currentform.rebuild_cost_per.value = "Sq. metres";
		}	  
		bedwise_price(currentform);
	}

	function change_rooms(form,value1,value2,newtype){
		  groundtype = newtype;
		  groundbeds = value1;
		  form.bedrooms.options.length = 0;

		  form.bedrooms.options[0] = new Option(value1,value1,false,false);
		  form.bedrooms.options[1] = new Option(value2,value2,false,false);
		  bedwise_price(form);
	}
	
	function bedroom_change(form){
		groundbeds = form.bedrooms.value;
		bedwise_price(form);
	}
	
	function fitting_change(form){
	  if (val_num(form.fittings.value,"Please enter a valid number without commas.")){
			groundfitting = form.fittings.value;
			form.fittings.value = ConvertToEurosCents(groundfitting);
	  }else{
			groundfitting = 0;
			form.fittings.value = 0;
	  }
	  bedwise_price(form);
	}
	function city_change(form,new_loc){
		  form.citylocation.value = new_loc;
		  groundlocation = new_loc;
		  bedwise_price(form);
	}
	
	
	function add_area(form){
	  var ground = parseFloat(form.ground.value);
	  var first = parseFloat(form.first.value);	 
	  if (val_num(form.ground.value,"The Ground Floor Area must be a number!") && val_num(form.first.value,"The First Floor Area must be a number!")){  
			form.total_area.value = ground + first;
			form.area2.value = ground + first;
	  }
	  bedwise_price(form);
	}
</script>

<?php 
	}else{
		echo "<div style='text-align:center;font-size:16px;font-weight:bold;'>Please enter cost details at admin area.</div>";
	}
	return ob_get_clean();
}
add_shortcode( 'calim_assist_calculator', 'sp_claim_calculator' );
?>