<?php
/**
 * Class Gcm file.
 *
 * @package CookieYes
 */

namespace WebToffee\CookieConsent\Lite\Admin\Modules\Gcm;

use WebToffee\CookieConsent\Lite\Includes\Modules;
use WebToffee\CookieConsent\Lite\Admin\Modules\Gcm\Api\Api;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Gcm extends Modules {
	/**
	 * Constructor.
	 */
	public function init() {
		$this->load_apis();
		add_filter( 'wcc_registered_admin_menus', array( $this, 'register_menus' ) );
	}

	/**
	 * Load API files
	 *
	 * @return void
	 */
	public function load_apis() {
		new Api();
	}

	/**
	 * Pass menu items to be registered.
	 *
	 * @param array $menus Sub menu array.
	 * @return array
	 */
	public function register_menus( $menus ) {
		$menus['gcm'] = array(
			'name'     => __( 'Google consent mode', 'webtoffee-cookie-consent' ),
			'callback' => array( $this, 'menu_page_template' ),
			'order'    => 3,
		);
		return $menus;
	}
	/**
	 * Main menu template
	 *
	 * @return void
	 */
	public function menu_page_template() {
		echo '<div id="wcc-app"></div>';
	}
}
