<?php
/**
 * Class Controller file.
 *
 * @package WebToffee
 */

namespace WebToffee\CookieConsent\Lite\Admin\Modules\Gcm\Includes;

use WebToffee\CookieConsent\Lite\Admin\Modules\Gcm\Includes\Gcm_Settings;
use WebToffee\CookieConsent\Lite\Includes\Base_Controller;

use WP_Error;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Controller extends Base_Controller {

	/**
	 * Instance of the current class
	 *
	 * @var object
	 */
	private static $instance;

	/**
	 * Return the current instance of the class
	 *
	 * @return object
	 */
	public static function get_instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}
		return self::$instance;
	}

	/**
	* Update gcm defualt consent
	* @since 3.1.0
	* @return array
	*/
	public function update_default_consents( $request ) {
		$data = isset( $request['content'] ) ? $request['content'] : '';
		update_option( 'wcc_gcm_default_consents', $data );
		return true;
	}
	/**
	* Get all the countries
	* @since 3.1.0
	* @return array
	*/
	public function get_all_countries() {
		return array(
			'ALL' => 'ALL',
			'AD'  => 'Andorra',
			'AE'  => 'United Arab Emirates',
			'AF'  => 'Afghanistan',
			'AG'  => 'Antigua and Barbuda',
			'AI'  => 'Anguilla',
			'AL'  => 'Albania',
			'AM'  => 'Armenia',
			'AO'  => 'Angola',
			'AR'  => 'Argentina',
			'AS'  => 'American Samoa',
			'AT'  => 'Austria',
			'AU'  => 'Australia',
			'AW'  => 'Aruba',
			'AX'  => 'Åland Islands',
			'AZ'  => 'Azerbaijan',
			'BA'  => 'Bosnia and Herzegovina',
			'BB'  => 'Barbados',
			'BD'  => 'Bangladesh',
			'BE'  => 'Belgium',
			'BF'  => 'Burkina Faso',
			'BG'  => 'Bulgaria',
			'BH'  => 'Bahrain',
			'BI'  => 'Burundi',
			'BJ'  => 'Benin',
			'BL'  => 'Saint Barthélemy',
			'BM'  => 'Bermuda',
			'BN'  => 'Brunei Darussalam',
			'BO'  => 'Bolivia',
			'BQ'  => 'Bonaire, Sint Eustatius and Saba',
			'BR'  => 'Brazil',
			'BS'  => 'Bahamas',
			'BT'  => 'Bhutan',
			'BV'  => 'Bouvet Island',
			'BW'  => 'Botswana',
			'BY'  => 'Belarus',
			'BZ'  => 'Belize',
			'CA'  => 'Canada',
			'CD'  => 'Democratic Republic of the Congo',
			'CF'  => 'Central African Republic',
			'CG'  => 'Congo',
			'CH'  => 'Switzerland',
			'CI'  => 'Côte d\'Ivoire',
			'CK'  => 'Cook Islands',
			'CL'  => 'Chile',
			'CM'  => 'Cameroon',
			'CN'  => 'China',
			'CO'  => 'Colombia',
			'CR'  => 'Costa Rica',
			'CU'  => 'Cuba',
			'CV'  => 'Cabo Verde',
			'CW'  => 'Curaçao',
			'CY'  => 'Cyprus',
			'CZ'  => 'Czechia',
			'DE'  => 'Germany',
			'DJ'  => 'Djibouti',
			'DK'  => 'Denmark',
			'DM'  => 'Dominica',
			'DO'  => 'Dominican Republic',
			'DZ'  => 'Algeria',
			'EC'  => 'Ecuador',
			'EE'  => 'Estonia',
			'EG'  => 'Egypt',
			'EH'  => 'Western Sahara',
			'ER'  => 'Eritrea',
			'ES'  => 'Spain',
			'ET'  => 'Ethiopia',
			'FI'  => 'Finland',
			'FJ'  => 'Fiji',
			'FM'  => 'Micronesia',
			'FO'  => 'Faroe Islands',
			'FR'  => 'France',
			'GA'  => 'Gabon',
			'GB'  => 'United Kingdom',
			'GD'  => 'Grenada',
			'GE'  => 'Georgia',
			'GF'  => 'French Guiana',
			'GG'  => 'Guernsey',
			'GH'  => 'Ghana',
			'GI'  => 'Gibraltar',
			'GL'  => 'Greenland',
			'GM'  => 'Gambia',
			'GN'  => 'Guinea',
			'GP'  => 'Guadeloupe',
			'GQ'  => 'Equatorial Guinea',
			'GR'  => 'Greece',
			'GT'  => 'Guatemala',
			'GU'  => 'Guam',
			'GW'  => 'Guinea-Bissau',
			'GY'  => 'Guyana',
			'HK'  => 'Hong Kong',
			'HM'  => 'Heard Island and McDonald Islands',
			'HN'  => 'Honduras',
			'HR'  => 'Croatia',
			'HT'  => 'Haiti',
			'HU'  => 'Hungary',
			'ID'  => 'Indonesia',
			'IE'  => 'Ireland',
			'IL'  => 'Israel',
			'IM'  => 'Isle of Man',
			'IN'  => 'India',
			'IO'  => 'British Indian Ocean Territory',
			'IQ'  => 'Iraq',
			'IR'  => 'Iran',
			'IS'  => 'Iceland',
			'IT'  => 'Italy',
			'JE'  => 'Jersey',
			'JM'  => 'Jamaica',
			'JO'  => 'Jordan',
			'JP'  => 'Japan',
			'KE'  => 'Kenya',
			'KG'  => 'Kyrgyzstan',
			'KH'  => 'Cambodia',
			'KI'  => 'Kiribati',
			'KM'  => 'Comoros',
			'KN'  => 'Saint Kitts and Nevis',
			'KP'  => 'North Korea',
			'KR'  => 'South Korea',
			'KW'  => 'Kuwait',
			'KY'  => 'Cayman Islands',
			'KZ'  => 'Kazakhstan',
			'LA'  => 'Lao People\'s Democratic Republic',
			'LB'  => 'Lebanon',
			'LC'  => 'Saint Lucia',
			'LI'  => 'Liechtenstein',
			'LK'  => 'Sri Lanka',
			'LR'  => 'Liberia',
			'LS'  => 'Lesotho',
			'LT'  => 'Lithuania',
			'LU'  => 'Luxembourg',
			'LV'  => 'Latvia',
			'LY'  => 'Libya',
			'MA'  => 'Morocco',
			'MC'  => 'Monaco',
			'MD'  => 'Moldova',
			'ME'  => 'Montenegro',
			'MF'  => 'Saint Martin',
			'MG'  => 'Madagascar',
			'MH'  => 'Marshall Islands',
			'MK'  => 'North Macedonia',
			'ML'  => 'Mali',
			'MM'  => 'Myanmar',
			'MN'  => 'Mongolia',
			'MO'  => 'Macao',
			'MP'  => 'Northern Mariana Islands',
			'MR'  => 'Mauritania',
			'MS'  => 'Montserrat',
			'MT'  => 'Malta',
			'MU'  => 'Mauritius',
			'MV'  => 'Maldives',
			'MW'  => 'Malawi',
			'MX'  => 'Mexico',
			'MY'  => 'Malaysia',
			'MZ'  => 'Mozambique',
			'NA'  => 'Namibia',
			'NC'  => 'New Caledonia',
			'NE'  => 'Niger',
			'NF'  => 'Norfolk Island',
			'NG'  => 'Nigeria',
			'NI'  => 'Nicaragua',
			'NL'  => 'Netherlands',
			'NO'  => 'Norway',
			'NP'  => 'Nepal',
			'NR'  => 'Nauru',
			'NU'  => 'Niue',
			'NZ'  => 'New Zealand',
			'OM'  => 'Oman',
			'PA'  => 'Panama',
			'PE'  => 'Peru',
			'PF'  => 'French Polynesia',
			'PG'  => 'Papua New Guinea',
			'PH'  => 'Philippines',
			'PK'  => 'Pakistan',
			'PL'  => 'Poland',
			'PM'  => 'Saint Pierre and Miquelon',
			'PN'  => 'Pitcairn',
			'PR'  => 'Puerto Rico',
			'PT'  => 'Portugal',
			'PW'  => 'Palau',
			'PY'  => 'Paraguay',
			'QA'  => 'Qatar',
			'RE'  => 'Réunion',
			'RO'  => 'Romania',
			'RS'  => 'Serbia',
			'RU'  => 'Russia',
			'RW'  => 'Rwanda',
			'SA'  => 'Saudi Arabia',
			'SB'  => 'Solomon Islands',
			'SC'  => 'Seychelles',
			'SD'  => 'Sudan',
			'SE'  => 'Sweden',
			'SG'  => 'Singapore',
			'SH'  => 'Saint Helena, Ascension and Tristan da Cunha',
			'SI'  => 'Slovenia',
			'SJ'  => 'Svalbard and Jan Mayen',
			'SK'  => 'Slovakia',
			'SL'  => 'Sierra Leone',
			'SM'  => 'San Marino',
			'SN'  => 'Senegal',
			'SO'  => 'Somalia',
			'SR'  => 'Suriname',
			'SS'  => 'South Sudan',
			'ST'  => 'Sao Tome and Principe',
			'SV'  => 'El Salvador',
			'SX'  => 'Sint Maarten',
			'SY'  => 'Syria',
			'SZ'  => 'Eswatini',
			'TC'  => 'Turks and Caicos Islands',
			'TD'  => 'Chad',
			'TF'  => 'French Southern Territories',
			'TG'  => 'Togo',
			'TH'  => 'Thailand',
			'TJ'  => 'Tajikistan',
			'TK'  => 'Tokelau',
			'TL'  => 'Timor-Leste',
			'TM'  => 'Turkmenistan',
			'TN'  => 'Tunisia',
			'TO'  => 'Tonga',
			'TR'  => 'Turkey',
			'TT'  => 'Trinidad and Tobago',
			'TV'  => 'Tuvalu',
			'TW'  => 'Taiwan',
			'TZ'  => 'Tanzania',
			'UA'  => 'Ukraine',
			'UG'  => 'Uganda',
			'UM'  => 'United States Minor Outlying Islands',
			'US'  => 'United States',
			'UY'  => 'Uruguay',
			'UZ'  => 'Uzbekistan',
			'VA'  => 'Holy See',
			'VC'  => 'Saint Vincent and the Grenadines',
			'VE'  => 'Venezuela',
			'VG'  => 'British Virgin Islands',
			'VI'  => 'United States Virgin Islands',
			'VN'  => 'Vietnam',
			'VU'  => 'Vanuatu',
			'WF'  => 'Wallis and Futuna',
			'WS'  => 'Samoa',
			'YE'  => 'Yemen',
			'YT'  => 'Mayotte',
			'ZA'  => 'South Africa',
			'ZM'  => 'Zambia',
			'ZW'  => 'Zimbabwe',
			// Continue to add more countries as per the list
		);
	}
	public function update_custom_meta_field() {}
	public function update_item( $content ) {}
	public function delete_item( $content ) {}
	public function create_item( $content ) {}
	protected function get_schema() {}
	protected function get_tables() {}
	protected function load_default() {}
	public function get_item_from_db( $args = array(), $fields = '' ) {
		return array();
	}
	public function prepare_item( $item ) {}
}
