<?php
/**
 * Class Policies file.
 *
 * @link       https://www.webtoffee.com/
 * @since      3.0.0
 * @package    WebToffee\CookieConsent\Lite\Admin\Modules\Policies\Includes
 */

namespace WebToffee\CookieConsent\Lite\Admin\Modules\Policies\Includes;

use WebToffee\CookieConsent\Lite\Includes\Store;
use WebToffee\CookieConsent\Lite\Admin\Modules\Policies\Includes\Controller;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Handles Cookies Operation
 *
 * @class       Policies
 * @version     3.0.0
 * @package     WebToffee
 */
class Policies extends Store {

	/**
	 * Policies controller class.
	 *
	 * @var object
	 */
	private $controller;

	/**
	 * Instance of the current class
	 *
	 * @var object
	 */
	private static $instance;

	/**
	 * Data array, with defaults.
	 *
	 * @var array
	 */
	protected $data = array(
		'policy_data'  => '',
		'date_created' => '',
	);

	/**
	 * Constructor
	 *
	 * @param mixed $data ID or slug of the cookie.
	 */
	public function __construct( $data = '' ) {
		$this->controller = Controller::get_instance();
		parent::__construct( $data );
		if ( is_int( $data ) && 0 !== $data ) {
			$this->set_id( $data );
		}
		if ( isset( $data->id ) ) {
			$this->set_id( $data->id );
			$this->read_direct( $data );
		} else {
			$this->get_data_from_db();
		}
	}
	/**
	 * Return the current instance of the class
	 *
	 * @return object
	 */
	public static function get_instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}
		return self::$instance;
	}
	/**
	 * Read directly from the data object given.
	 * Used for assigning data to object if it is alread fetched from API or DB.
	 *
	 * @param array|object $data Policies data.
	 * @return void
	 */
	public function read_direct( $data ) {
		$this->set_data( $data );
	}

	/**
	 * Assign data to objects
	 *
	 * @param array|object $data Array of data.
	 * @return void
	 */
	public function set_data( $data ) {
		if ( isset( $data->id ) ) {
			$this->set_multi_item_data(
				array(
					'policy_data' => $data->policy_data,
				)
			);
			$this->set_loaded( true );
		}
	}
	/**
	 * Read policy data from database
	 *
	 * @param object $policies Instance of Policies.
	 * @return void
	 */
	public function read( $policies ) {
		$policies->set_defaults();
		$data = $this->controller->get_item( $policies->get_id() );
		$this->set_data( $data );
	}

	/**
	 * Insert a new Policies on the database.
	 *
	 * @param object $policies Consent Policies object.
	 * @return void
	 */
	public function create( $policies ) {
		$this->controller->create_item( $policies );
	}
	/**
	 * Update Policies data
	 *
	 * @param object $policies Instance of Policies.
	 * @return void
	 */
	public function update( $policies ) {
		$this->controller->update_item( $policies );
	}

	/**
	 * Check if an array is associative or indexed
	 *
	 * @param array $arr Input array.
	 * @return Boolean
	 */
	public static function array_has_key( $arr ) {
		if ( count( array_filter( array_keys( $arr ), 'is_string' ) ) === 0 ) {
			return false;
		}
		return true;
	}
	/**
	 * Get default policy data
	 *
	 * @since  3.0.0
	 * @return string
	 */
	public function get_policy_data() {
		return wcc_sanitize_content( $this->get_object_data( 'policy_data' ) );
	}
	public function set_policy_data( $content ) {
		// error_log($content);
		$this->set_object_data( 'policy_data', wcc_sanitize_content( $content ) );
	}
}
