import wccRest from "@/helpers/api";

export default {
    async createGcm(data) {
        try {
            const response = await wccRest.post({
                path: `gcm/`,
                data: data,
            });
            return response;
        } catch (error) {
            console.error(error);
        }
    },
    async getConsents() {
        try {
            const response = await wccRest.get({
                path: `gcm/`,
            });
            return response;
        } catch (error) {
            console.error(error);
        }
    },
    async saveConsents(data) {
        try {
            const response = await wccRest.post({
                path: `gcm/defaultconsents`,
                data: { content: data },
            });
            return response;
        } catch (error) {
            console.error(error);
        }
    },
    async allRegions() {
        try {
            const response = await wccRest.get({
                path: `gcm/regions`,
            });
            return response;
        } catch (error) {
            console.error(error);
        }
    },
}