import api from "@/modules/cookies/helpers/api";

const banners = {
    namespaced: true,
    state: {
        items: false,
    },

    getters: {
        /**
         * Get the all settings object.
         *
         * @param {object} state Current state.
         *
         * @return {*}
         */
        getItems: (state) => {
            return state.items
        },

    },

    mutations: {
        /**
         * Update a single value in store.
         *
         * Updates the value only on store.
         * Call updateSettings mutation to store the values in db.
         *
         * @param {object} state Current state.
         * @param {object} data Data to update.
         */
        setItems: (state, data) => {
            state.items = data
        },
    },

    actions: {
        /**
         * Re-initialize the settings store forcefully.
         *
         * We need to call the API and get the settings,
         * then update the store state with the new values.
         *
         * @param commit Commit
         * @param {object} data Custom params.
         *
         * @return {Promise<void>}
         */
        reInit: async ({ commit }) => {
            try {
                const response = await api.getCookieCategories();
                const items = [];
                if (response instanceof Array) {
                    response.forEach(function (item) {
                        items.push(item);
                    });
                    commit('setItems', items);
                }
            } catch (error) {
                console.error(error);
            }

        },

        /**
        /**
         * Update the settings values in db.
         *
         * Use the API and update the whole values.
         * Only do this when required.
         *
         * @param {object} Commit and State.
         * @param {object} data Custom params.
         *
         * @return {boolean}
         */
        bulkUpdate: async ({ state, dispatch }) => {
            let success = false;
            let response = await api.bulkUpdateCookieCategory(state.items);
            if (response.length > 0) {
                success = true;
                dispatch('reInit');
            }
            return success
        },
    },
}
export default banners