const path = require('path')
const TerserPlugin = require('terser-webpack-plugin');

module.exports = {
	mode: 'production',
	entry: {
		script: path.resolve(__dirname, '../../frontend/js/script.js'),
		gcm: path.resolve(__dirname, '../../frontend/js/gcm.js'),
		wca: path.resolve(__dirname, '../../frontend/js/wca.js'),
		mcm: path.resolve(__dirname, '../../frontend/js/mcm.js'),
	},
	output: {
		path: path.resolve(__dirname, '../../frontend/js/'),
		filename: '[name].min.js',
	},
	optimization: {
		minimize: true,
		minimizer: [
			new TerserPlugin({
				terserOptions: {
					mangle: false, // Disable name mangling for all variables and functions
					compress: {},
					format: {},
				},
				extractComments: false, // Don't output a separate file for comments
			}),
		],
	},
};